using System.Net;
using System.Net.Sockets;
using System.Text;

namespace KoAla_Next_S {
 public partial class Form1 : Form {
  private TcpListener listener;
  private Thread serverThread;
  public Form1() {
   InitializeComponent();
   InitializeWebView();
  }

  private async void InitializeWebView() {
   await webView.EnsureCoreWebView2Async(null);
   webView.CoreWebView2.Navigate("https://www.gonet.tv/onlinetv/?lang=pl#1");
   webView.CoreWebView2.DOMContentLoaded += async (s, e) => {
    timerInit.Enabled = true;
   };
  }

  private void Form1_Load(object sender, EventArgs e) {
   serverThread = new Thread(StartServer);
   serverThread.IsBackground = true;
   serverThread.Start();
  }

  private async void timerInit_Tick(object sender, EventArgs e) {
   string jsCode = "station.PlayStation(34);";
   await webView.ExecuteScriptAsync(jsCode);
   timerInit.Enabled = false;
  }

  private void StartServer() {
   try {
    listener = new TcpListener(IPAddress.Any, 5000);
    listener.Start();
    while(true) {
     TcpClient client = listener.AcceptTcpClient();
     ThreadPool.QueueUserWorkItem(HandleClient, client);
    }
   }
   catch(Exception ex) {
    Log("Bd serwera: " + ex.Message);
   }
  }
  private async void HandleClient(object obj) {
   TcpClient client = (TcpClient)obj;
   NetworkStream stream = client.GetStream();

   byte[] buffer = new byte[1024];
   int bytesRead = stream.Read(buffer, 0, buffer.Length);

   string receivedText = Encoding.UTF8.GetString(buffer, 0, bytesRead);
   string response = "";
   if(receivedText == "dzie") {
    response = "dobry";
   } else {
    Log(receivedText);
    response = receivedText;
   }
   // Opcjonalna odpowied
   byte[] responseBytes = Encoding.UTF8.GetBytes(response);
   stream.Write(responseBytes, 0, responseBytes.Length);
   client.Close();
  }

  private void Log(string message) {
   if(txtLog.InvokeRequired) {
    txtLog.Invoke(new Action(() => txtLog.Text = message));
   } else {
    txtLog.Text = message;
   }
  }

  private async void txtLog_TextChanged(object sender, EventArgs e) {
   string jsCode = "station.PlayStation(" + txtLog.Text + ");";
   await webView.ExecuteScriptAsync(jsCode);
  }
 }
}
